/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.cleanup;

import com.ibm.hwmca.base.cleanup.CleanUpFiles;
import com.ibm.hwmca.base.cleanup.RemovableFiles;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.TreeMap;

public class BaseCleanUpFilesImpl
implements CleanUpFiles {
    protected TreeMap removableItems;
    protected String cleanupFilesFileName;
    protected String TRACE_MASKT = "XCCLBAST";
    protected String TRACE_MASKF = "XCCLBASF";
    protected String TRACE_MASKD = "XCCLBASD";

    public BaseCleanUpFilesImpl() {
        try {
            this.cleanupFilesFileName = BaseFileControl.getFilePath("basecleanupfiles.ini") + "basecleanupfiles.ini";
        }
        catch (HException he) {
            Trace.trace(this.TRACE_MASKF, "Error in getting file path");
            this.cleanupFilesFileName = "basecleanupfiles.ini";
        }
        this.removableItems = new TreeMap();
    }

    public void prepare() {
        Trace.trace(this.TRACE_MASKT, "-> prepare()");
        try {
            String s;
            File f = new File(this.cleanupFilesFileName);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
            while ((s = br.readLine()) != null) {
                if ((s = s.trim()).length() <= 0 || s.startsWith("#")) continue;
                try {
                    RemovableFiles rf = (RemovableFiles)Class.forName(s).newInstance();
                    this.removableItems.put(rf.getRemovalKey(), rf);
                }
                catch (ClassNotFoundException cnfe) {
                    Trace.trace(this.TRACE_MASKT, "Class not found: " + s);
                }
                catch (InstantiationException ie) {
                    Trace.trace(this.TRACE_MASKT, "Instantiation Exception: " + s);
                }
                catch (IllegalAccessException iae) {
                    Trace.trace(this.TRACE_MASKT, "Illegal Access Exception: " + s);
                }
                catch (ClassCastException cce) {
                    Trace.trace(this.TRACE_MASKT, "Class cast exception: " + s);
                }
            }
            br.close();
        }
        catch (IOException ioe) {
            Trace.trace(this.TRACE_MASKT, "IO exception: " + ioe);
        }
        Trace.trace(this.TRACE_MASKT, "<- prepare() ");
    }

    public RemovableFiles[] getRemovableItems() {
        RemovableFiles[] removableFiles = new RemovableFiles[this.removableItems.size()];
        int i = 0;
        Iterator iterator = this.removableItems.keySet().iterator();
        while (iterator.hasNext()) {
            String removalKey = (String)iterator.next();
            removableFiles[i] = (RemovableFiles)this.removableItems.get(removalKey);
            ++i;
        }
        return removableFiles;
    }

    public void removeItem(String removalKey) {
        RemovableFiles rf = (RemovableFiles)this.removableItems.get(removalKey);
        rf.removeFiles();
    }
}

